<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/init.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$supplier = isset($_POST['supplier']) ? trim($_POST['supplier']) : '';
$certificate = isset($_POST['certificate']) ? trim($_POST['certificate']) : '';
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$note = isset($_POST['note']) ? trim($_POST['note']) : '';

if (empty($supplier) || empty($certificate) || empty($name) || empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email address']);
    exit;
}

try {
    // Get admin email from settings
    $adminEmail = get_setting('as_admin_email', 'admin@example.com');
    
    // Prepare email content (German)
    $subject = 'Anfrage für manuelle Überprüfung';
    $body = '<html><body style="font-family: Space Grotesk, sans-serif;">';
    $body .= '<table rules="all" style="border: 1px solid #ccc; border-collapse: collapse; width: 100%;">';
    $body .= '<tr style="background-color: #f5f5f5;"><td style="padding: 10px; border: 1px solid #ccc;"><strong>Lieferant:</strong></td><td style="padding: 10px; border: 1px solid #ccc;">' . htmlspecialchars($supplier) . '</td></tr>';
    $body .= '<tr><td style="padding: 10px; border: 1px solid #ccc;"><strong>Zertifikatsnummer:</strong></td><td style="padding: 10px; border: 1px solid #ccc;">' . htmlspecialchars($certificate) . '</td></tr>';
    $body .= '<tr style="background-color: #f5f5f5;"><td style="padding: 10px; border: 1px solid #ccc;"><strong>Name:</strong></td><td style="padding: 10px; border: 1px solid #ccc;">' . htmlspecialchars($name) . '</td></tr>';
    $body .= '<tr><td style="padding: 10px; border: 1px solid #ccc;"><strong>E-Mail:</strong></td><td style="padding: 10px; border: 1px solid #ccc;">' . htmlspecialchars($email) . '</td></tr>';
    $body .= '<tr style="background-color: #f5f5f5;"><td style="padding: 10px; border: 1px solid #ccc;"><strong>Nachricht:</strong></td><td style="padding: 10px; border: 1px solid #ccc;">' . nl2br(htmlspecialchars($note)) . '</td></tr>';
    $body .= '</table>';
    $body .= '</body></html>';
    
    // Send email via application mail function
    $emailError = null;
    $sent = send_mail_message($adminEmail, $subject, $body, true, $emailError);
    
    if ($sent) {
        echo json_encode(['success' => true, 'message' => 'Anfrage eingereicht']);
    } else {
        error_log('Manual investigation email failed: ' . ($emailError ?? 'Unknown error'));
        // Still return success to user, but log the error
        echo json_encode(['success' => true, 'message' => 'Anfrage eingereicht']);
    }
    
} catch (Exception $e) {
    error_log('Manual investigation error: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Server error']);
}
