<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/init.php';

// Supplier name autocomplete search
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$query = isset($_POST['q']) ? trim($_POST['q']) : '';

if (strlen($query) < 2) {
    echo json_encode(['success' => false, 'suppliers' => []]);
    exit;
}

try {
    $db = getDB();
    
    // Search for suppliers with LIKE matching (case-insensitive)
    $stmt = $db->prepare("
        SELECT DISTINCT username 
        FROM " . table('WPAS_csv') . "
        WHERE username LIKE ? 
        ORDER BY username ASC 
        LIMIT 10
    ");
    
    $searchTerm = '%' . $query . '%';
    $stmt->execute([$searchTerm]);
    $suppliers = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);
    
    echo json_encode([
        'success' => true,
        'suppliers' => $suppliers ?: []
    ]);
    
} catch (Exception $e) {
    error_log('Supplier search error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error',
        'suppliers' => []
    ]);
}
