<?php
// Run this to create the MySQL table using settings in includes/config.php
// Usage: php mysql_install.php [username] [email] [password]
$cfg = include __DIR__ . '/includes/config.php';
try {
    $dsn = sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $cfg['db_host'], $cfg['db_name']);
    $pdo = new PDO($dsn, $cfg['db_user'], $cfg['db_pass'], [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $sql = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        email VARCHAR(255) NOT NULL UNIQUE,
        password_hash VARCHAR(255) NOT NULL,
        reset_token VARCHAR(255) DEFAULT NULL,
        reset_expires INT DEFAULT NULL,
        pending_email VARCHAR(255) DEFAULT NULL,
        email_token VARCHAR(255) DEFAULT NULL,
        email_expires INT DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $pdo->exec($sql);
    echo "Table 'users' created or exists.\n";

    // Check if any user exists
    $stmt = $pdo->query('SELECT COUNT(*) AS c FROM users');
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $count = intval($row['c'] ?? 0);

    // Allow optional CLI args to create initial admin: php mysql_install.php admin admin@example.com secret
    $argvUsername = $argv[1] ?? null;
    $argvEmail = $argv[2] ?? null;
    $argvPass = $argv[3] ?? null;

    if ($count === 0) {
        if ($argvEmail && $argvPass) {
            $email = $argvEmail;
            $pass = $argvPass;
        } else {
            // default credentials
            $email = 'admin@example.com';
            $pass = 'admin123';
        }
        $hash = password_hash($pass, PASSWORD_DEFAULT);
        $ins = $pdo->prepare('INSERT INTO users (email, password_hash) VALUES (?, ?)');
        $ins->execute([$email, $hash]);
        echo "Created initial admin user:\n";
        echo "  Email: {$email}\n";
        echo "  Password: {$pass}\n";
        echo "Please change the password after first login.\n";
    } else {
        echo "Users already exist in the table; no initial user created.\n";
    }

    echo "Done.\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
