<?php
require_once __DIR__ . '/../includes/init.php';
require_login();

$user = find_user_by_id($_SESSION['user_id']);
$msg = '';
$error = '';
$suppliers = [];
$search_query = '';
$total_suppliers = 0;
$perPage = 20;
$pagination = null;

// Get search query
if (isset($_GET['s'])) {
    $search_query = trim($_GET['s']);
}

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $supplier_id = (int)($_POST['supplier_id'] ?? 0);
    if ($supplier_id > 0) {
        try {
            $db = getDB();
            $stmt = $db->prepare("DELETE FROM " . table('WPAS_csv') . " WHERE id = ?");
            $stmt->execute([$supplier_id]);
            $msg = 'Lieferant erfolgreich gelöscht.';
        } catch (Exception $e) {
            $error = 'Fehler beim Löschen: ' . $e->getMessage();
        }
    }
}

// Get suppliers
try {
    $db = getDB();
    $tableName = table('WPAS_csv');
    
    if ($search_query) {
        $searchTerm = '%' . $search_query . '%';

        $countStmt = $db->prepare("
            SELECT COUNT(*) 
            FROM " . $tableName . "
            WHERE username LIKE ? OR certificate LIKE ?
        ");
        $countStmt->execute([$searchTerm, $searchTerm]);
        $total_suppliers = (int)$countStmt->fetchColumn();

        $pagination = get_pagination_data($total_suppliers, $perPage, 'page');
        $limit = (int)$pagination['per_page'];
        $offset = (int)$pagination['offset'];

        $stmt = $db->prepare("
            SELECT * FROM " . $tableName . "
            WHERE username LIKE ? OR certificate LIKE ?
            ORDER BY username ASC
            LIMIT {$limit} OFFSET {$offset}
        ");
        $stmt->execute([$searchTerm, $searchTerm]);
    } else {
        $countStmt = $db->query("SELECT COUNT(*) FROM " . $tableName);
        $total_suppliers = (int)$countStmt->fetchColumn();

        $pagination = get_pagination_data($total_suppliers, $perPage, 'page');
        $limit = (int)$pagination['per_page'];
        $offset = (int)$pagination['offset'];

        $stmt = $db->query("
            SELECT * FROM " . $tableName . "
            ORDER BY username ASC
            LIMIT {$limit} OFFSET {$offset}
        ");
    }

    $suppliers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error = 'Fehler beim Abrufen der Lieferanten: ' . $e->getMessage();
}
?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Lieferanten verwalten</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="wp-admin admin-suppliers">
<?php render_admin_topbar($user['email']); ?>
<div class="container layout">
    <?php render_admin_sidebar('suppliers'); ?>
    <main class="main">
        <h1>Lieferanten verwalten</h1>
        
        <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
        <?php if($msg): ?><div class="notice success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>

        <div class="stats">
            <div class="stat-card">
                <div class="stat-label">Gesamt Lieferanten</div>
                <div class="stat-number"><?php echo $total_suppliers; ?></div>
            </div>
        </div>

        <div class="card">
            <h2>Lieferanten durchsuchen</h2>
            
            <div class="search-box">
                <form method="get" style="flex: 1; display: flex; gap: 10px;">
                    <input 
                        type="text" 
                        name="s" 
                        placeholder="Nach Name oder Zertifikat suchen..." 
                        value="<?php echo htmlspecialchars($search_query); ?>"
                    >
                    <button type="submit">Suchen</button>
                    <?php if ($search_query): ?>
                    <a href="suppliers.php" class="btn-small" style="padding: 10px 15px;">Zurücksetzen</a>
                    <?php endif; ?>
                </form>
            </div>

            <?php if (empty($suppliers)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <p><?php echo $search_query ? 'Keine Lieferanten gefunden.' : 'Keine Lieferanten vorhanden. <a href="csv-import.php">CSV importieren</a>.'; ?></p>
            </div>
            <?php else: ?>
            <div style="overflow-x: auto;">
                <table class="suppliers-table">
                    <thead>
                        <tr>
                            <th style="width: 30%;">Lieferant (Name)</th>
                            <th style="width: 30%;">Zertifikatsnummer</th>
                            <th style="width: 25%;">Produkttyp</th>
                            <th style="width: 15%;">Aktionen</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($suppliers as $supplier): ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($supplier['username']); ?></strong></td>
                            <td><code><?php echo htmlspecialchars($supplier['certificate']); ?></code></td>
                            <td><?php echo htmlspecialchars($supplier['product'] ?? '-'); ?></td>
                            <td>
                                <div class="actions">
                                    <a href="edit-supplier.php?id=<?php echo $supplier['id']; ?>" class="btn-small edit">
                                        <i class="fas fa-edit"></i> Bearbeiten
                                    </a>
                                    <button type="button" class="btn-small delete" onclick="openDeleteModal(<?php echo $supplier['id']; ?>, '<?php echo htmlspecialchars(addslashes($supplier['username'])); ?>')">
                                        <i class="fas fa-trash"></i> Löschen
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($pagination) && $pagination['total_pages'] > 1): ?>
            <div class="pagination-wrap">
                <div class="pagination-info">
                    Zeige <?php echo (int)$pagination['from_item']; ?> bis <?php echo (int)$pagination['to_item']; ?>
                    von <?php echo (int)$pagination['total_items']; ?> Einträgen
                </div>
                <?php render_admin_pagination($pagination); ?>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>

    </main>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal">
    <div class="modal-content">
        <h2>Lieferant löschen</h2>
        <p>Möchten Sie <strong id="deleteSupplierName">-</strong> wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden.</p>
        <form id="deleteForm" method="post">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="supplier_id" id="deleteSupplierID" value="">
            <div class="modal-actions">
                <button type="button" class="btn-cancel" onclick="closeDeleteModal()">Abbrechen</button>
                <button type="submit" class="btn-delete">Ja, löschen</button>
            </div>
        </form>
    </div>
</div>

<?php render_admin_footer(); ?>

<script>
function openDeleteModal(id, name) {
    document.getElementById('deleteSupplierID').value = id;
    document.getElementById('deleteSupplierName').textContent = name;
    document.getElementById('deleteModal').classList.add('active');
}

function closeDeleteModal() {
    document.getElementById('deleteModal').classList.remove('active');
}

// Close modal when clicking outside
document.getElementById('deleteModal').addEventListener('click', function(e) {
    if (e.target === this) closeDeleteModal();
});
</script>

</body>
</html>


