<?php
require_once __DIR__ . '/../includes/init.php';
require_login();

$user = find_user_by_id($_SESSION['user_id']);
$error = '';
$records = [];
$total_records = 0;
$perPage = 20;
$pagination = null;
$filter_result = '';

// Handle filters
if (isset($_GET['result'])) {
    $filter_result = trim($_GET['result']);
}

// Get records
try {
    $db = getDB();
    $tableName = table('WPAS_search_record');
    
    if ($filter_result !== '') {
        $countStmt = $db->prepare("SELECT COUNT(*) FROM " . $tableName . " WHERE result = ?");
        $countStmt->execute([$filter_result]);
        $total_records = (int)$countStmt->fetchColumn();

        $pagination = get_pagination_data($total_records, $perPage, 'page');
        $limit = (int)$pagination['per_page'];
        $offset = (int)$pagination['offset'];

        $stmt = $db->prepare("
            SELECT * FROM " . $tableName . "
            WHERE result = ?
            ORDER BY date DESC
            LIMIT {$limit} OFFSET {$offset}
        ");
        $stmt->execute([$filter_result]);
    } else {
        $countStmt = $db->query("SELECT COUNT(*) FROM " . $tableName);
        $total_records = (int)$countStmt->fetchColumn();

        $pagination = get_pagination_data($total_records, $perPage, 'page');
        $limit = (int)$pagination['per_page'];
        $offset = (int)$pagination['offset'];

        $stmt = $db->prepare("
            SELECT * FROM " . $tableName . " 
            ORDER BY date DESC 
            LIMIT {$limit} OFFSET {$offset}
        ");
        $stmt->execute();
    }
    
    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error = 'Fehler beim Abrufen der Abfrage-Protokolle: ' . $e->getMessage();
}

// Get statistics
$successful = 0;
$failed = 0;
foreach ($records as $record) {
    if ($record['result'] == 1) {
        $successful++;
    } else {
        $failed++;
    }
}
?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Abfrage-Protokoll</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="wp-admin admin-search-records">
<?php render_admin_topbar($user['email']); ?>
<div class="container layout">
    <?php render_admin_sidebar('search_records'); ?>
    <main class="main">
        <h1>Abfrage-Protokoll</h1>
        
        <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

        <div class="stats">
            <div class="stat-card">
                <div class="stat-label">Gesamt Abfragen</div>
                <div class="stat-number stat-total"><?php echo $total_records; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Erfolgreich</div>
                <div class="stat-number stat-success"><?php echo $successful; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Fehlgeschlagen</div>
                <div class="stat-number stat-failed"><?php echo $failed; ?></div>
            </div>
        </div>

        <div class="card">
            <h2>Filter</h2>
            <div class="filter-buttons">
                <a href="search-records.php" class="filter-btn <?php echo $filter_result === '' ? 'active' : ''; ?>">
                    <i class="fas fa-list"></i> Alle
                </a>
                <a href="search-records.php?result=1" class="filter-btn <?php echo $filter_result === '1' ? 'active' : ''; ?>">
                    <i class="fas fa-check" style="color: #28a745;"></i> Erfolgreich
                </a>
                <a href="search-records.php?result=0" class="filter-btn <?php echo $filter_result === '0' ? 'active' : ''; ?>">
                    <i class="fas fa-times" style="color: #dc3545;"></i> Fehlgeschlagen
                </a>
            </div>
        </div>

        <div class="card">
            <h2>Abfrage-Verlauf</h2>
            
            <?php if (empty($records)): ?>
            <div class="empty-state">
                <i class="fas fa-search"></i>
                <p>Keine Abfragen gefunden.</p>
            </div>
            <?php else: ?>
            <div style="overflow-x: auto;">
                <table class="records-table">
                    <thead>
                        <tr>
                            <th style="width: 20%;">Lieferant</th>
                            <th style="width: 25%;">Zertifikat</th>
                            <th style="width: 20%;">Ergebnis</th>
                            <th style="width: 35%;">Zeitstempel</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($records as $record): ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($record['username']); ?></strong></td>
                            <td><code><?php echo htmlspecialchars($record['certificate']); ?></code></td>
                            <td>
                                <span class="status-badge <?php echo $record['result'] == 1 ? 'status-success' : 'status-failed'; ?>">
                                    <?php echo $record['result'] == 1 ? '✓ Gefunden' : '✕ Nicht gefunden'; ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($record['date']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="records-summary">
                Zeige <?php echo count($records); ?> von <?php echo $total_records; ?> Einträgen
            </div>
            <?php if (!empty($pagination) && $pagination['total_pages'] > 1): ?>
            <div class="pagination-wrap">
                <div class="pagination-info">
                    Seite <?php echo (int)$pagination['current_page']; ?> von <?php echo (int)$pagination['total_pages']; ?>
                </div>
                <?php render_admin_pagination($pagination); ?>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>

    </main>
</div>

<?php render_admin_footer(); ?>

</body>
</html>


