<?php
require_once __DIR__ . '/../includes/init.php';
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $user = find_user_by_email($email);
    if ($user) {
        $token = create_reset_token($user['id']);
        $resetLink = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http')
            . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/reset.php?token=' . $token;
        // In a real app, email $resetLink to the user. For this standalone scaffold we'll display it.
        $message = 'Password reset link (copy and open in browser): <br><a href="' . htmlspecialchars($resetLink) . '">' . htmlspecialchars($resetLink) . '</a>';
    } else {
        $message = 'If that email exists, a reset link was generated.';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Password Reset</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="login-page">
<div class="login-wrap">
    <h1 class="wp-brand">Password Reset</h1>
    <?php if($message): ?><div class="notice info"><?php echo $message; ?></div><?php endif; ?>
    <form method="post">
        <label>Email address
            <input type="email" name="email" required>
        </label>
        <div class="form-actions">
            <button type="submit" class="btn">Request Reset</button>
            <a class="link" href="login.php">Back to login</a>
        </div>
    </form>
</div>
</body>
</html>
