<?php
require_once __DIR__ . '/../includes/init.php';
$token = $_GET['token'] ?? '';
$error = '';
$success = '';
$user = null;
if ($token) {
    $user = find_user_by_token($token);
    if (!$user) $error = 'Invalid or expired token.';
} else {
    $error = 'Token missing.';
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $user) {
    $pw = $_POST['password'] ?? '';
    $pw2 = $_POST['password2'] ?? '';
    if ($pw !== $pw2) {
        $error = 'Passwords do not match.';
    } elseif (strlen($pw) < 6) {
        $error = 'Password too short (min 6 chars).';
    } else {
        set_user_password($user['id'], $pw);
        $success = 'Password updated. You may now <a href="login.php">sign in</a>.';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Set New Password</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="login-page">
<div class="login-wrap">
    <h1 class="wp-brand">Set New Password</h1>
    <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
    <?php if($success): ?><div class="notice success"><?php echo $success; ?></div><?php endif; ?>
    <?php if(!$success && !$error || ($user && !$success && $error)): ?>
    <form method="post">
        <label>New password
            <input type="password" name="password" required>
        </label>
        <label>Confirm password
            <input type="password" name="password2" required>
        </label>
        <div class="form-actions">
            <button type="submit" class="btn">Set Password</button>
        </div>
    </form>
    <?php endif; ?>
</div>
</body>
</html>
