<?php
require_once __DIR__ . '/../includes/init.php';
if (is_logged_in()) {
    header('Location: dashboard.php'); exit;
}
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $user = find_user_by_email($email);
    if ($user && password_verify($password, $user['password_hash'])) {
        login_user($user);
        header('Location: dashboard.php'); exit;
    } else {
        $error = 'Invalid email or password.';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Admin Login</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="login-page">
<div class="login-wrap">
    <h1 class="wp-brand">FFV Zertifikat — Admin</h1>
    <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
    <form method="post">
        <label>Email
            <input type="email" name="email" required>
        </label>
        <label>Password
            <input type="password" name="password" required>
        </label>
        <div class="form-actions">
            <button type="submit" class="btn">Sign In</button>
            <a class="link" href="reset_request.php">Forgot password?</a>
        </div>
    </form>
</div>
</body>
</html>
