<?php
require_once __DIR__ . '/../includes/init.php';
require_login();

$user = find_user_by_id($_SESSION['user_id']);
$error = '';
$reports = [];
$total_reports = 0;
$perPage = 20;
$pagination = null;
$typeStats = [];

// Get email reports
try {
    $db = getDB();
    $tableName = table('WPAS_email_reports');

    $countStmt = $db->query("SELECT COUNT(*) FROM " . $tableName);
    $total_reports = (int)$countStmt->fetchColumn();
    $pagination = get_pagination_data($total_reports, $perPage, 'page');
    $limit = (int)$pagination['per_page'];
    $offset = (int)$pagination['offset'];

    $stmt = $db->query("
        SELECT * FROM " . $tableName . "
        ORDER BY date DESC
        LIMIT {$limit} OFFSET {$offset}
    ");
    $reports = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $statsStmt = $db->query("
        SELECT type, COUNT(*) AS cnt
        FROM " . $tableName . "
        GROUP BY type
    ");
    $typeStats = $statsStmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
} catch (Exception $e) {
    $error = 'Fehler beim Abrufen der Email Reports: ' . $e->getMessage();
}

// Count by type
$automatic_count = (int)($typeStats['Automatic'] ?? 0);
$manual_count = (int)($typeStats['Manual'] ?? 0);
?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Email Reports</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="wp-admin admin-email-reports">
<?php render_admin_topbar($user['email']); ?>
<div class="container layout">
    <?php render_admin_sidebar('email_reports'); ?>
    <main class="main">
        <h1>Email Reports</h1>
        
        <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

        <div class="stats">
            <div class="stat-card">
                <div class="stat-label">Gesamt Reports</div>
                <div class="stat-number"><?php echo $total_reports; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Automatisch</div>
                <div class="stat-number"><?php echo $automatic_count; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Manuell</div>
                <div class="stat-number"><?php echo $manual_count; ?></div>
            </div>
        </div>

        <div class="card">
            <h2>Report-Verlauf</h2>
            
            <p style="color: #666; margin-bottom: 20px;">
                <strong>Automatische Reports:</strong> Werden alle 14 Tage automatisch versendet<br>
                <strong>Manuelle Reports:</strong> Werden auf Anfrage versendet
            </p>

            <?php if (empty($reports)): ?>
            <div class="empty-state">
                <i class="fas fa-envelope"></i>
                <p>Keine Email Reports vorhanden.</p>
            </div>
            <?php else: ?>
            <div style="overflow-x: auto;">
                <table class="reports-table">
                    <thead>
                        <tr>
                            <th style="width: 20%;">Typ</th>
                            <th style="width: 30%;">Anzahl Einträge</th>
                            <th style="width: 50%;">Zeitstempel</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($reports as $report): ?>
                        <tr>
                            <td>
                                <span class="type-badge <?php echo $report['type'] === 'Automatic' ? 'type-automatic' : 'type-manual'; ?>">
                                    <i class="fas fa-<?php echo $report['type'] === 'Automatic' ? 'clock' : 'hand-point-right'; ?>"></i>
                                    <?php echo $report['type'] === 'Automatic' ? 'Automatisch' : 'Manuell'; ?>
                                </span>
                            </td>
                            <td><strong><?php echo htmlspecialchars($report['total_amount_requests']); ?></strong> Abfragen</td>
                            <td><?php echo htmlspecialchars($report['date']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php if (!empty($pagination) && $pagination['total_pages'] > 1): ?>
            <div class="pagination-wrap">
                <div class="pagination-info">
                    Zeige <?php echo (int)$pagination['from_item']; ?> bis <?php echo (int)$pagination['to_item']; ?>
                    von <?php echo (int)$pagination['total_items']; ?> Einträgen
                </div>
                <?php render_admin_pagination($pagination); ?>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>

        <div class="card">
            <h2>Informationen</h2>
            <p>Email Reports enthalten eine Zusammenfassung aller Zertifikatsabfragen, die in den letzten Tagen durchgeführt wurden.</p>
            <ul style="margin: 15px 0 0 20px;">
                <li>Automatische Reports werden alle 14 Tage versendet</li>
                <li>Manuelle Reports können über die <a href="settings.php">Einstellungen</a> versendet werden</li>
                <li>Die Anzahl der Abfragen wird pro Report erfasst</li>
            </ul>
        </div>

    </main>
</div>

<?php render_admin_footer(); ?>

</body>
</html>


