<?php
require_once __DIR__ . '/../includes/init.php';
require_login();

$user = find_user_by_id($_SESSION['user_id']);
$msg = '';
$error = '';
$supplier = null;
$supplier_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Get supplier
if ($supplier_id > 0) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM " . table('WPAS_csv') . " WHERE id = ? LIMIT 1");
        $stmt->execute([$supplier_id]);
        $supplier = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$supplier) {
            $error = 'Lieferant nicht gefunden.';
        }
    } catch (Exception $e) {
        $error = 'Fehler beim Abrufen des Lieferanten: ' . $e->getMessage();
    }
}

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update') {
    $username = trim($_POST['username'] ?? '');
    $certificate = trim($_POST['certificate'] ?? '');
    $product = trim($_POST['product'] ?? '');
    
    if (empty($username) || empty($certificate)) {
        $error = 'Name und Zertifikat sind erforderlich.';
    } else if (!$supplier_id) {
        $error = 'Ungültige Lieferanten-ID.';
    } else {
        try {
            $db = getDB();
            $stmt = $db->prepare("
                UPDATE " . table('WPAS_csv') . "
                SET username = ?, certificate = ?, product = ?
                WHERE id = ?
            ");
            $stmt->execute([$username, $certificate, $product, $supplier_id]);
            
            $msg = 'Lieferant erfolgreich aktualisiert.';
            
            // Refresh supplier data
            $stmt = $db->prepare("SELECT * FROM " . table('WPAS_csv') . " WHERE id = ? LIMIT 1");
            $stmt->execute([$supplier_id]);
            $supplier = $stmt->fetch(PDO::FETCH_ASSOC);
            
        } catch (Exception $e) {
            $error = 'Fehler beim Aktualisieren: ' . $e->getMessage();
        }
    }
}

if (!$supplier && $supplier_id > 0) {
    // Don't show form if supplier not found
} elseif (!$supplier) {
    $error = 'Lieferanten-ID erforderlich.';
}
?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Lieferant bearbeiten</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
</head>
<body class="wp-admin admin-edit-supplier">
<?php render_admin_topbar($user['email']); ?>
<div class="container layout">
    <?php render_admin_sidebar('suppliers'); ?>
    <main class="main">
        <h1>Lieferant bearbeiten</h1>
        
        <?php if($error): ?><div class="notice error"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>
        <?php if($msg): ?><div class="notice success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>

        <?php if ($supplier): ?>
        <div class="card">
            <h2><?php echo htmlspecialchars($supplier['username']); ?></h2>
            <p style="color: #999; margin-bottom: 20px;">ID: <?php echo $supplier['id']; ?></p>
            
            <form method="post">
                <input type="hidden" name="action" value="update">
                
                <div class="form-group">
                    <label for="username">Lieferantenname *</label>
                    <input 
                        type="text" 
                        id="username" 
                        name="username" 
                        value="<?php echo htmlspecialchars($supplier['username']); ?>"
                        required
                    >
                </div>

                <div class="form-group">
                    <label for="certificate">Zertifikatsnummer *</label>
                    <input 
                        type="text" 
                        id="certificate" 
                        name="certificate" 
                        value="<?php echo htmlspecialchars($supplier['certificate']); ?>"
                        required
                    >
                </div>

                <div class="form-group">
                    <label for="product">Produkttyp (optional)</label>
                    <input 
                        type="text" 
                        id="product" 
                        name="product" 
                        value="<?php echo htmlspecialchars($supplier['product'] ?? ''); ?>"
                        placeholder="z.B. Fichte, Kiefer, Eiche"
                    >
                </div>

                <div class="form-actions">
                    <button class="btn" type="submit">Änderungen speichern</button>
                    <a href="suppliers.php" class="btn" style="background-color: #6c757d;">Abbrechen</a>
                </div>
            </form>
        </div>

        <div class="card">
            <h2>Informationen</h2>
            <table style="width: 100%;">
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 10px; width: 30%;"><strong>ID:</strong></td>
                    <td style="padding: 10px;"><?php echo $supplier['id']; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 10px;"><strong>Erstellt am:</strong></td>
                    <td style="padding: 10px;"><?php echo htmlspecialchars($supplier['date']); ?></td>
                </tr>
            </table>
        </div>

        <?php else: ?>
        <div class="notice error">
            <p><?php echo htmlspecialchars($error ?: 'Lieferant nicht gefunden.'); ?></p>
            <a href="suppliers.php" class="btn" style="margin-top: 15px; display: inline-block;">Zurück zu Lieferanten</a>
        </div>
        <?php endif; ?>

    </main>
</div>

<?php render_admin_footer(); ?>

</body>
</html>



