<?php
require_once __DIR__ . '/../includes/init.php';
require_login();
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Diagnostics</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
</head>
<body class="wp-admin admin-diagnostics">
<?php render_admin_topbar($_SESSION['email']); ?>
<div class="container layout">
    <?php render_admin_sidebar('settings'); ?>
    <main class="main">
        <h1>Email Diagnostics</h1>

        <div class="card">
            <h2>Current SMTP Configuration</h2>
            <?php
            $smtpHost = get_setting('smtp_host', '');
            $smtpPort = get_setting('smtp_port', '587');
            $smtpUser = get_setting('smtp_user', '');
            $smtpPass = get_setting('smtp_pass', '');
            $smtpSecure = get_setting('smtp_secure', '');
            $fromEmail = get_setting('from_email', '');
            $fromName = get_setting('from_name', '');
            ?>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>SMTP Host:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($smtpHost ?: '[NOT SET]'); ?></code></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>SMTP Port:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($smtpPort); ?></code></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>SMTP User:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($smtpUser ?: '[NOT SET]'); ?></code></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>SMTP Password:</strong></td>
                    <td style="padding: 8px;"><code><?php echo $smtpPass ? '[SET - ' . strlen($smtpPass) . ' chars]' : '[NOT SET]'; ?></code></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>Security Type:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($smtpSecure ?: '[NONE]'); ?></code></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 8px;"><strong>From Email:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($fromEmail); ?></code></td>
                </tr>
                <tr>
                    <td style="padding: 8px;"><strong>From Name:</strong></td>
                    <td style="padding: 8px;"><code><?php echo htmlspecialchars($fromName); ?></code></td>
                </tr>
            </table>
        </div>

        <?php if (empty($smtpHost)): ?>
        <div class="warning">
            <strong>No SMTP configured!</strong><br>
            Emails are being sent using PHP's <code>mail()</code> function, which is unreliable on development servers.<br>
            <br>
            <strong>What to do:</strong>
            <ol>
                <li>Go to <a href="settings.php">Settings</a> and configure SMTP settings</li>
                <li>For testing, you can use:<br>
                    <strong>SMTP Host:</strong> smtp.mailtrap.io or your mail server<br>
                    <strong>SMTP Port:</strong> 587 (for TLS) or 465 (for SSL)<br>
                    <strong>Security:</strong> TLS or SSL<br>
                    <strong>Username &amp; Password:</strong> Your SMTP credentials
                </li>
            </ol>
        </div>
        <?php else: ?>
        <div class="info">
            <strong>SMTP configured</strong><br>
            Emails should be sent via SMTP: <?php echo htmlspecialchars($smtpHost . ':' . $smtpPort); ?> (<?php echo htmlspecialchars($smtpSecure ?: 'no encryption'); ?>)
        </div>
        <?php endif; ?>

        <div class="card">
            <h2>Email Log</h2>
            <?php
            $logFile = APP_ROOT . '/logs/email.log';
            if (file_exists($logFile)) {
                $logContent = file_get_contents($logFile);
                if (empty(trim($logContent))) {
                    echo '<p>Email log is empty. Send a test email to see logs appear here.</p>';
                } else {
                    echo '<div class="code-block">' . htmlspecialchars($logContent) . '</div>';
                }
            } else {
                echo '<p>No email log yet. Send a test email to generate logs.</p>';
            }
            ?>
        </div>

        <div class="card">
            <h2>What to check</h2>
            <h3>If emails don't arrive:</h3>
            <ol>
                <li><strong>Check spam folder</strong> - PHP mail() often goes to spam/junk</li>
                <li><strong>Verify From address</strong> - The "From Email" must be valid for your domain or SMTP server</li>
                <li><strong>Use proper SMTP</strong> - Configure SMTP instead of relying on PHP mail()</li>
                <li><strong>Check email log</strong> - Look at the log above to see what method was used</li>
            </ol>

            <h3>Recommended SMTP providers for testing:</h3>
            <ul style="margin-left: 20px;">
                <li>Mailtrap.io (free tier, great for testing)</li>
                <li>Gmail SMTP (requires app password for 2FA accounts)</li>
                <li>Your hosting provider's SMTP (check with support)</li>
            </ul>
        </div>
    </main>
</div>

<?php render_admin_footer(); ?>

</body>
</html>
