<?php
require_once __DIR__ . '/../includes/init.php';
require_login();
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    logout_user();
    header('Location: login.php'); exit;
}

$user = find_user_by_id($_SESSION['user_id']);
$email = $user['email'] ?? 'Admin';

// Get statistics
$stats = [
    'total_suppliers' => 0,
    'total_searches' => 0,
    'successful_searches' => 0,
    'failed_searches' => 0,
    'total_reports' => 0
];

try {
    $db = getDB();
    
    // Total suppliers
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM " . table('WPAS_csv'));
    $stmt->execute();
    $stats['total_suppliers'] = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    // Total and successful searches
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM " . table('WPAS_search_record'));
    $stmt->execute();
    $stats['total_searches'] = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM " . table('WPAS_search_record') . " WHERE result = 1");
    $stmt->execute();
    $stats['successful_searches'] = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
    $stats['failed_searches'] = $stats['total_searches'] - $stats['successful_searches'];
    
    // Total reports
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM " . table('WPAS_email_reports'));
    $stmt->execute();
    $stats['total_reports'] = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
    
} catch (Exception $e) {
    error_log('Dashboard stats error: ' . $e->getMessage());
}
?>
<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin-pages.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="wp-admin admin-dashboard">
<?php render_admin_topbar($email); ?>
<div class="container layout">
    <?php render_admin_sidebar('dashboard'); ?>
    <main class="main">
        <h1>Dashboard</h1>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-boxes"></i></div>
                <div class="stat-label">Lieferanten</div>
                <div class="stat-value"><?php echo $stats['total_suppliers']; ?></div>
            </div>

            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-search"></i></div>
                <div class="stat-label">Gesamt Abfragen</div>
                <div class="stat-value"><?php echo $stats['total_searches']; ?></div>
            </div>

            <div class="stat-card">
                <div class="stat-icon" style="color: #28a745;"><i class="fas fa-check-circle"></i></div>
                <div class="stat-label">Erfolgreich</div>
                <div class="stat-value" style="color: #28a745;"><?php echo $stats['successful_searches']; ?></div>
            </div>

            <div class="stat-card">
                <div class="stat-icon" style="color: #dc3545;"><i class="fas fa-times-circle"></i></div>
                <div class="stat-label">Fehlgeschlagen</div>
                <div class="stat-value" style="color: #dc3545;"><?php echo $stats['failed_searches']; ?></div>
            </div>

            <div class="stat-card">
                <div class="stat-icon"><i class="fas fa-envelope"></i></div>
                <div class="stat-label">Email Reports</div>
                <div class="stat-value"><?php echo $stats['total_reports']; ?></div>
            </div>
        </div>

        <div class="card">
            <h2>Schnell-Aktionen</h2>
            <div class="quick-actions">
                <a href="csv-import.php" class="action-card">
                    <div class="action-icon"><i class="fas fa-file-upload"></i></div>
                    <div class="action-title">CSV Importieren</div>
                    <small>Neue Lieferantendaten hochladen</small>
                </a>

                <a href="suppliers.php" class="action-card">
                    <div class="action-icon"><i class="fas fa-users"></i></div>
                    <div class="action-title">Lieferanten verwalten</div>
                    <small>Anschauen und bearbeiten</small>
                </a>

                <a href="search-records.php" class="action-card">
                    <div class="action-icon"><i class="fas fa-history"></i></div>
                    <div class="action-title">Abfrage-Protokoll</div>
                    <small>Alle Suchvorgänge anschauen</small>
                </a>

                <a href="email-reports.php" class="action-card">
                    <div class="action-icon"><i class="fas fa-envelope-open"></i></div>
                    <div class="action-title">Email Reports</div>
                    <small>Versendete Reports anschauen</small>
                </a>

                <a href="settings.php" class="action-card">
                    <div class="action-icon"><i class="fas fa-cog"></i></div>
                    <div class="action-title">Einstellungen</div>
                    <small>Plugin konfigurieren</small>
                </a>
            </div>
        </div>

        <div class="card">
            <h2>Willkommen 👋</h2>
            <p>Dies ist die Admin-Verwaltungsoberfläche für das FFV Zertifikat Abfrage Plugin. Von hier aus können Sie alle Aspekte des Plugins verwalten.</p>
            <ul style="margin: 15px 0 0 20px;">
                <li>✓ <strong>Lieferanten verwalten:</strong> CSV importieren, Einträge anschauen und bearbeiten</li>
                <li>✓ <strong>Abfragen überwachen:</strong> Alle Suchanfragen und deren Ergebnisse einsehen</li>
                <li>✓ <strong>Email Reports verwalten:</strong> Automatische und manuelle Reports anschauen</li>
                <li>✓ <strong>Einstellungen konfigurieren:</strong> Admin-E-Mail, Rate Limiting und SMTP</li>
            </ul>
        </div>
    </main>
</div>

<?php render_admin_footer(); ?>

</body>
</html>


