<?php
require_once __DIR__ . '/../includes/init.php';
$token = $_GET['token'] ?? '';
$message = '';
if ($token) {
    $user = find_user_by_email_token($token);
    if ($user) {
        $ok = confirm_email_change($user['id']);
        if ($ok) {
            $message = 'Email updated successfully.';
        } else {
            $message = 'Unable to update email.';
        }
    } else {
        $message = 'Invalid or expired token.';
    }
} else {
    $message = 'Token missing.';
}
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Confirm Email</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="login-page">
<div class="login-wrap">
    <h1 class="wp-brand">Email Confirmation</h1>
    <div class="notice info"><?php echo htmlspecialchars($message); ?></div>
    <p><a href="login.php">Back to login</a> or <a href="dashboard.php">Dashboard</a></p>
</div>
</body>
</html>
